<?php

namespace Import\ApiBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Import\ApiBundle\Entity\ContributionZUS;
use Import\ApiBundle\Entity\InterestRateFPAndFGSP;

/**
 * InterestRateFPAndFGSP
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class InterestRateFPAndFGSPRepository extends EntityRepository
{
    /**
     * add new ContributionZUS
     *
     * @param $data
     * @param bool $flush
     * @return ContributionZUS
     */
    public function add($data, $flush = false)
    {
        $InterestRateFPAndFGSP = new InterestRateFPAndFGSP();

        $InterestRateFPAndFGSP->setMonthFrom($data['month']);
        $InterestRateFPAndFGSP->setYearFrom($data['year']);
        $InterestRateFPAndFGSP->setMonthTo($data['monthTo']);
        $InterestRateFPAndFGSP->setYearTo($data['yearTo']);
        $InterestRateFPAndFGSP->setDescription($data['description']);

        $InterestRateFPAndFGSP->setInterestRateFP($data['value']['FP']);
        $InterestRateFPAndFGSP->setInterestRateFGSP($data['value']['FGSP']);

        $this->getEntityManager()->persist($InterestRateFPAndFGSP);
        if($flush)
        {
            $this->getEntityManager()->flush();
        }

        return $InterestRateFPAndFGSP;
    }

    /**
     * @param $monthFrom
     * @param $yearFrom
     * @param $monthTo
     * @param $yearTo
     * @return null|ContributionZUS
     */
    public function getInterestRateFPAndFGSPForMonthAndYear($monthFrom,$yearFrom,$monthTo,$yearTo)
    {
        $QueryBuilder = $this->createQueryBuilder('p');
        $QueryBuilder
            ->select('p')
            ->where($QueryBuilder->expr()->eq('p.yearFrom',$yearFrom))
            ->andWhere($QueryBuilder->expr()->eq('p.monthFrom',$monthFrom))
            ->andWhere($QueryBuilder->expr()->eq('p.yearTo',$yearTo))
            ->andWhere($QueryBuilder->expr()->eq('p.monthTo',$monthTo))
            ->setMaxResults(1)
        ;

        return $QueryBuilder->getQuery()->getOneOrNullResult();
    }
}
